C      *****************************************************************
C      * Function CtoM                                                 *
C      * Assigns the correct multiplication factor for conversion of   *
C      * concentration to mass, in liters, based on whether the passed *
C      * component is aqueous or solid and what the current layer is.  *
C      *                                                               *
C      * Variables:                                                    *
C      * AqCtoM    -Input - A vector, of size NLayers, of              *
C      *                    multiplication factors which convert       *
C      *                    aqueous concentrations to mass. There is   *
C      *                    one multiplication factor for each layer.  *
C      *                    Units are L.                               *
C      *                    (Common block VModel, file VModel.f)       *
C      * LNum      -Input - The current layer number.  Unitless.       *
C      * SolidCtoM -Input - A vector, of size NLayers, of              *
C      *                    multiplication factors which convert solid *
C      *                    concentrations to mass.  There is one      *
C      *                    multiplication factor for each layer.      *
C      *                    Units are L.                               *
C      *                    (Common block VModel, file VModel.f)       *
C      * SPMasBal  -Input - Indicates a solid phase species type       *
C      *                    limited by mass balance.  Unitless.        *
C      *                    (Common block VModel, file VModel.f)       *
C      * SType     -Input - A vector, of size NSpecies, of each        *
C      *                    species's type.  Unitless.                 *
C      *                    (Common block VModel, file VModel.f)       *
C      *****************************************************************
       REAL*8 FUNCTION CTOM(COMP,LNUM)
							IMPLICIT NONE
							INCLUDE 'VMODEL.INC'
							INTEGER COMP, LNUM

       IF (STYPE(COMP).LT.SPMASBAL) THEN
	         CTOM = AQCTOM(LNUM)
       ELSE
  	      CTOM = SOLIDCTOM(LNUM)
       ENDIF

	      RETURN
	      END
C      *****************************************************************
C      *                    END SUBROUTINE                             *
C      *****************************************************************
